/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.moc.Healpix;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.RandomAccessFile;
import java.util.Iterator;

public class BuilderCut
extends Builder {
    static int NB = 0;
    protected long startTime;
    protected long totalTime;
    private int statNbFile;

    public BuilderCut(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CUT;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void build() throws Exception {
        this.context.loadMoc();
        String path = this.context.getOutputPath();
        SMoc moc = new SMoc();
        moc.read(path + cds.tools.Util.FS + "Moc.fits");
        int order = Util.getMaxOrderByPath(path);
        if (this.context.getOrder() == -1) {
            this.context.setOrder(order);
        }
        moc.setMocOrder(order);
        this.initStat((int)moc.getNbValues());
        SMoc[] mocs = moc.split(new Healpix(), true);
        this.context.info(mocs.length + " independent regions found");
        this.context.info("Updating FITS tile headers with CUTMIN and CUTMAX values by region...");
        double pourcentMin = 0.003;
        double pourcentMax = 0.9995;
        if (Context.hasPourcentCut(this.context.pixelRangeCut)) {
            pourcentMin = this.context.pixelRangeCut[5];
            pourcentMax = this.context.pixelRangeCut[6];
        }
        String u = cds.tools.Util.getUnitDisk(this.getByRegionWidth() * this.getByRegionWidth());
        u = u.substring(0, u.length() - 1) + "pix";
        this.context.info("Adjusting cuts from " + cds.tools.Util.getPourcent(pourcentMin) + " to " + cds.tools.Util.getPourcent(pourcentMax) + " of the pixel distribution for each region (based on " + u + ")");
        for (SMoc m : mocs) {
            this.setCut(path, order, m);
        }
    }

    private void setCut(String path, int order, SMoc moc) throws Exception {
        double[] cut = this.evaluateCut(path, order, moc);
        String cutmin = cut[0] + "";
        String cutmax = cut[1] + "";
        Iterator<Long> it = moc.valIterator();
        while (it.hasNext()) {
            int code;
            long npix = it.next();
            String file = Util.getFilePath(path, order, npix) + ".fits";
            Fits fits = new Fits();
            try {
                code = fits.loadHeaderFITS(file);
            }
            catch (Exception e) {
                this.updateStat();
                continue;
            }
            if (code != 0) {
                throw new Exception("FITS tile header update error (not a regular FITS tile))");
            }
            byte[] buf1 = fits.headerFits.makeHeaderBuf();
            fits.headerFits.setKeyword("CUTMIN", cutmin);
            fits.headerFits.setKeyword("CUTMAX", cutmax);
            byte[] buf2 = fits.headerFits.makeHeaderBuf();
            if (buf2.length != buf1.length) {
                throw new Exception("FITS tile header update error (>2880)");
            }
            RandomAccessFile f = new RandomAccessFile(file, "rw");
            f.write(buf2);
            f.close();
            this.updateStat();
        }
    }

    private int getByRegionWidth() {
        int w = (int)Math.sqrt(this.context.byRegionSize);
        if (w < 64) {
            w = 1024;
        }
        return w;
    }

    private double[] evaluateCut(String path, int order, SMoc moc) throws Exception {
        int i = 0;
        Iterator<Long> it = moc.valIterator();
        Fits test = null;
        int offset = 0;
        int testW = this.getByRegionWidth();
        while (it.hasNext()) {
            long npix = it.next();
            String file = Util.getFilePath(path, order, npix) + ".fits";
            try {
                Fits fits = new Fits(file);
                if (test == null) {
                    test = new Fits(testW, testW, fits.bitpix);
                    test.setBlank(fits.blank);
                    test.setBscale(fits.bscale);
                    test.setBzero(fits.bzero);
                    test.initBlank();
                }
                int size = fits.width * fits.height;
                for (int j = 0; j < size && offset < testW * testW; ++j) {
                    double c = fits.getPixValDouble(fits.pixels, fits.bitpix, j);
                    if (fits.isBlankPixel(c)) continue;
                    Fits.setPixValDouble(test.pixels, test.bitpix, offset++, c);
                }
                if (offset != testW * testW) continue;
                break;
            }
            catch (Exception e) {
                --i;
            }
        }
        double cutMinPourcent = -1.0;
        double cutMaxPourcent = -1.0;
        if (Context.hasPourcentCut(this.context.pixelRangeCut)) {
            cutMinPourcent = this.context.pixelRangeCut[5];
            cutMaxPourcent = this.context.pixelRangeCut[6];
        }
        double[] cut = test.findAutocutRange(0.0, 0.0, cutMinPourcent, cutMaxPourcent, true);
        return cut;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }

    @Override
    public boolean isAlreadyDone() {
        return false;
    }

    private void initStat(int n) {
        this.context.setProgressMax(n);
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 1, 1);
    }
}

